/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.formatter.internal;

import com.aptana.editor.ruby.formatter.internal.RubyFormatterNodeBuilder;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterArrayNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterAtBeginNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterAtEndNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterBeginNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterCaseNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterClassNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterDoNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterElseIfNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterEnsureNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterForNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterHashNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterIfElseNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterIfEndNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterIfNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterMethodNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterModuleNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterRequireNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterRescueElseNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterRescueNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterStringNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterUntilNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterWhenElseNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterWhenNode;
import com.aptana.editor.ruby.formatter.internal.nodes.FormatterWhileNode;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.ruby.core.ast.AbstractVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.jrubyparser.ISourcePositionHolder;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.BeginNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DRegexpNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.EnsureNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Match2Node;
import org.jrubyparser.ast.Match3Node;
import org.jrubyparser.ast.MatchNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.OptArgNode;
import org.jrubyparser.ast.PostExeNode;
import org.jrubyparser.ast.PreExeNode;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.RescueBodyNode;
import org.jrubyparser.ast.RescueNode;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.UntilNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.WhenNode;
import org.jrubyparser.ast.WhileNode;
import org.jrubyparser.ast.XStrNode;

public class RubyFormatterNodeBuilderVisitor
extends AbstractVisitor {
    private IFormatterDocument document;
    private RubyFormatterNodeBuilder builder;
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("\r?\n|\r");
    protected static final Comparator<Node> POSITION_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node n1, Node n2) {
            return n1.getPosition().getStartOffset() - n2.getPosition().getStartOffset();
        }
    };

    protected RubyFormatterNodeBuilderVisitor(IFormatterDocument document, RubyFormatterNodeBuilder builder) {
        this.document = document;
        this.builder = builder;
    }

    protected Object visitNode(Node visited) {
        this.visitChildren(visited);
        return null;
    }

    public Object visitClassNode(ClassNode visited) {
        int bodyEndOffset;
        FormatterClassNode classNode = new FormatterClassNode(this.document);
        SourcePosition position = visited.getPosition();
        classNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)visited.getCPath().getPosition().getStartOffset()));
        this.builder.push((IFormatterContainerNode)classNode);
        Node bodyNode = visited.getBodyNode();
        if (NodeType.NILNODE.equals((Object)bodyNode.getNodeType())) {
            bodyEndOffset = classNode.getEndOffset();
        } else {
            bodyNode.accept((NodeVisitor)this);
            bodyEndOffset = bodyNode.getPosition().getEndOffset();
        }
        this.builder.checkedPop((IFormatterContainerNode)classNode, bodyEndOffset);
        classNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitSClassNode(SClassNode visited) {
        FormatterClassNode classNode = new FormatterClassNode(this.document);
        SourcePosition position = visited.getPosition();
        classNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)visited.getReceiverNode().getPosition().getStartOffset()));
        this.builder.push((IFormatterContainerNode)classNode);
        this.visitChildren((Node)visited);
        Node bodyNode = visited.getBodyNode();
        Node receiverNode = visited.getReceiverNode();
        int bodyEndOffset = position.getEndOffset();
        if (bodyNode != null) {
            bodyEndOffset = bodyNode.getPosition().getEndOffset();
        } else if (receiverNode != null) {
            bodyEndOffset = receiverNode.getPosition().getEndOffset();
        }
        this.builder.checkedPop((IFormatterContainerNode)classNode, bodyEndOffset);
        classNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitModuleNode(ModuleNode visited) {
        FormatterModuleNode moduleNode = new FormatterModuleNode(this.document);
        Colon3Node pathNode = visited.getCPath();
        moduleNode.setBegin(this.createTextNode(this.document, (ISourcePositionHolder)pathNode));
        this.builder.push((IFormatterContainerNode)moduleNode);
        this.visitChildren((Node)visited);
        SourcePosition position = visited.getPosition();
        Node bodyNode = visited.getBodyNode();
        int bodyEndOffset = bodyNode instanceof NilImplicitNode ? moduleNode.getEndOffset() : bodyNode.getPosition().getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)moduleNode, bodyEndOffset);
        moduleNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitDefnNode(DefnNode visited) {
        return this.visitMethodDefNode((MethodDefNode)visited);
    }

    public Object visitDefsNode(DefsNode visited) {
        return this.visitMethodDefNode((MethodDefNode)visited);
    }

    private Object visitMethodDefNode(MethodDefNode visited) {
        FormatterMethodNode methodNode = new FormatterMethodNode(this.document);
        SourcePosition position = visited.getPosition();
        methodNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)visited.getNameNode().getPosition().getEndOffset()));
        this.builder.push((IFormatterContainerNode)methodNode);
        this.visitChildren((Node)visited);
        Node bodyNode = visited.getBodyNode();
        int bodyEndOffset = bodyNode != null ? bodyNode.getPosition().getEndOffset() : this.locateEndOffset(this.document, position.getEndOffset());
        this.builder.checkedPop((IFormatterContainerNode)methodNode, bodyEndOffset);
        methodNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitWhileNode(WhileNode visited) {
        FormatterWhileNode whileNode = new FormatterWhileNode(this.document);
        SourcePosition position = visited.getPosition();
        Node conditionNode = visited.getConditionNode();
        whileNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)conditionNode.getPosition().getEndOffset()));
        this.builder.push((IFormatterContainerNode)whileNode);
        Node bodyNode = visited.getBodyNode();
        this.visitChildren(bodyNode);
        int bodyEndOffset = bodyNode instanceof NilImplicitNode ? whileNode.getEndOffset() : bodyNode.getPosition().getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)whileNode, bodyEndOffset);
        whileNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitIterNode(IterNode visited) {
        FormatterDoNode forNode = new FormatterDoNode(this.document);
        Node varNode = visited.getVarNode();
        Node bodyNode = visited.getBodyNode();
        SourcePosition position = visited.getPosition();
        boolean isCurlyIteration = this.document.charAt(position.getStartOffset()) == '{';
        int beginEndOffset = position.getEndOffset();
        if (bodyNode != null) {
            beginEndOffset = bodyNode.getPosition().getStartOffset();
        } else if (varNode != null) {
            beginEndOffset = varNode.getPosition().getEndOffset();
            if (isCurlyIteration) {
                if (this.document.charAt(beginEndOffset - 1) != '}') {
                    beginEndOffset = position.getEndOffset() - 1;
                }
            } else {
                int endKeywordStart = this.charLookup(this.document, beginEndOffset, 'e');
                if (endKeywordStart > -1) {
                    beginEndOffset = endKeywordStart;
                }
            }
        } else {
            beginEndOffset = this.locateEndOffset(this.document, position.getEndOffset());
        }
        forNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)beginEndOffset));
        this.builder.push((IFormatterContainerNode)forNode);
        this.visitChildren((Node)visited);
        int bodyEndOffset = bodyNode != null ? bodyNode.getPosition().getEndOffset() : forNode.getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)forNode, bodyEndOffset);
        forNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)Math.max(bodyEndOffset, position.getEndOffset())));
        return null;
    }

    public Object visitForNode(ForNode visited) {
        FormatterForNode forNode = new FormatterForNode(this.document);
        Node bodyNode = visited.getBodyNode();
        Node iterNode = visited.getIterNode();
        int bodyStart = -1;
        int bodyEnd = -1;
        SourcePosition position = visited.getPosition();
        if (iterNode != null) {
            bodyStart = iterNode.getPosition().getEndOffset();
        }
        if (bodyNode != null) {
            if (bodyStart < 0) {
                bodyStart = this.locateEndOffset(this.document, position.getEndOffset());
            }
            bodyEnd = bodyNode.getPosition().getEndOffset() - 1;
        } else {
            if (bodyStart < 0) {
                bodyStart = this.locateEndOffset(this.document, position.getEndOffset());
            }
            if (bodyEnd < 0) {
                bodyEnd = bodyStart;
            }
        }
        forNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)bodyStart));
        this.builder.push((IFormatterContainerNode)forNode);
        if (bodyNode != null) {
            bodyNode.accept((NodeVisitor)this);
        }
        this.builder.checkedPop((IFormatterContainerNode)forNode, bodyEnd);
        forNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEnd, (int)position.getEndOffset()));
        return null;
    }

    public Object visitUntilNode(UntilNode visited) {
        FormatterUntilNode untilNode = new FormatterUntilNode(this.document);
        untilNode.setBegin(this.createTextNode(this.document, (ISourcePositionHolder)visited));
        this.builder.push((IFormatterContainerNode)untilNode);
        this.visitChildren((Node)visited);
        SourcePosition position = visited.getPosition();
        Node bodyNode = visited.getBodyNode();
        int bodyEndOffset = bodyNode.getPosition().getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)untilNode, bodyEndOffset);
        untilNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitCaseNode(CaseNode visited) {
        ArrayList<Node> children;
        FormatterCaseNode caseNode = new FormatterCaseNode(this.document);
        SourcePosition position = visited.getPosition();
        caseNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)visited.getCaseNode().getPosition().getEndOffset()));
        this.builder.push((IFormatterContainerNode)caseNode);
        Node branch = visited.getFirstWhenNode();
        if (branch instanceof ArrayNode) {
            children = branch.childNodes();
        } else {
            children = new ArrayList<Node>();
            children.add(branch);
        }
        int bodyEndOffset = position.getEndOffset();
        for (Node child : children) {
            if (child instanceof WhenNode) {
                WhenNode whenBranch = (WhenNode)child;
                FormatterWhenNode whenNode = new FormatterWhenNode(this.document);
                SourcePosition branchPosition = child.getPosition();
                whenNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)branchPosition.getStartOffset(), (int)whenBranch.getExpressionNodes().getPosition().getEndOffset()));
                this.builder.push((IFormatterContainerNode)whenNode);
                Node whenBodyNode = whenBranch.getBodyNode();
                this.visitChild(whenBodyNode);
                this.builder.checkedPop((IFormatterContainerNode)whenNode, whenBodyNode.getPosition().getEndOffset());
                bodyEndOffset = whenNode.getEndOffset();
                continue;
            }
            FormatterWhenElseNode whenElseNode = new FormatterWhenElseNode(this.document);
            SourcePosition elsePosition = child.getPosition();
            whenElseNode.setBegin(this.createTextNode(this.document, (ISourcePositionHolder)child));
            this.builder.push((IFormatterContainerNode)whenElseNode);
            this.visitChildren(child.childNodes());
            this.builder.checkedPop((IFormatterContainerNode)whenElseNode, elsePosition.getEndOffset());
            bodyEndOffset = whenElseNode.getEndOffset();
        }
        this.builder.checkedPop((IFormatterContainerNode)caseNode, bodyEndOffset);
        caseNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitIfNode(IfNode visited) {
        SourcePosition position = visited.getPosition();
        if (this.isInSameLineExcludingWhitespaces(position)) {
            ArrayList<Node> children = new ArrayList<Node>(3);
            if (visited.getThenBody() != null) {
                children.add(visited.getThenBody());
            }
            if (visited.getElseBody() != null) {
                children.add(visited.getElseBody());
            }
            if (visited.getCondition() != null) {
                children.add(visited.getCondition());
            }
            if (!children.isEmpty()) {
                Collections.sort(children, POSITION_COMPARATOR);
                this.visitChildren(children);
            }
            return null;
        }
        FormatterIfNode ifNode = new FormatterIfNode(this.document);
        ifNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)visited.getCondition().getPosition().getEndOffset()));
        this.builder.push((IFormatterContainerNode)ifNode);
        Node thenBody = visited.getThenBody();
        Node elseBody = visited.getElseBody();
        if (thenBody instanceof ReturnNode || elseBody instanceof ReturnNode) {
            this.builder.checkedPop((IFormatterContainerNode)ifNode, ifNode.getEndOffset());
            return null;
        }
        int ifNodeEnd = -1;
        if (elseBody != null) {
            ifNodeEnd = elseBody.getPosition().getEndOffset();
        } else if (thenBody != null) {
            ifNodeEnd = thenBody.getPosition().getEndOffset();
        }
        if (elseBody != null && thenBody != null && thenBody.getPosition().getStartOffset() > elseBody.getPosition().getStartOffset()) {
            ifNodeEnd = thenBody.getPosition().getEndOffset();
            Node temp = thenBody;
            thenBody = elseBody;
            elseBody = temp;
        }
        this.visitChild(thenBody);
        if (thenBody == null && elseBody != null) {
            this.visitChild(elseBody);
        }
        this.builder.checkedPop((IFormatterContainerNode)ifNode, ifNode.getEndOffset());
        while (elseBody != null && thenBody != null) {
            if (elseBody instanceof IfNode) {
                IfNode elseIfBranch = (IfNode)elseBody;
                FormatterElseIfNode elseIfNode = new FormatterElseIfNode(this.document);
                elseIfNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)thenBody.getPosition().getEndOffset(), (int)elseIfBranch.getCondition().getPosition().getEndOffset()));
                this.builder.push((IFormatterContainerNode)elseIfNode);
                thenBody = elseIfBranch.getThenBody();
                this.visitChild(thenBody);
                elseBody = elseIfBranch.getElseBody();
                this.builder.checkedPop((IFormatterContainerNode)elseIfNode, elseIfNode.getEndOffset());
                continue;
            }
            FormatterIfElseNode elseNode = new FormatterIfElseNode(this.document);
            elseNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)thenBody.getPosition().getEndOffset(), (int)elseBody.getPosition().getStartOffset()));
            this.builder.push((IFormatterContainerNode)elseNode);
            this.visitChild(elseBody);
            this.builder.checkedPop((IFormatterContainerNode)elseNode, elseNode.getEndOffset());
            elseBody = null;
        }
        if (ifNodeEnd < 0) {
            ifNodeEnd = this.locateEndOffset(this.document, position.getEndOffset());
        }
        this.builder.addChild((IFormatterNode)new FormatterIfEndNode(this.document, ifNodeEnd, position.getEndOffset()));
        return null;
    }

    public Object visitBeginNode(BeginNode visited) {
        FormatterBeginNode beginNode = new FormatterBeginNode(this.document);
        SourcePosition beginPosition = visited.getPosition();
        Node bodyNode = visited.getBodyNode();
        RescueBodyNode rescueBodyNode = null;
        int beginEndOffset = -1;
        if (bodyNode instanceof EnsureNode) {
            EnsureNode ensureNode = (EnsureNode)bodyNode;
            bodyNode = ensureNode.getBodyNode();
            Node innerEnsureNode = ensureNode.getEnsureNode();
            if (!(innerEnsureNode instanceof NilImplicitNode)) {
                beginEndOffset = innerEnsureNode.getPosition().getEndOffset();
            }
        }
        if (bodyNode instanceof RescueNode) {
            RescueNode rescueNode = (RescueNode)bodyNode;
            bodyNode = rescueNode.getBodyNode();
            rescueBodyNode = rescueNode.getRescueNode();
        }
        if (bodyNode instanceof NilImplicitNode) {
            if (beginEndOffset < 0) {
                beginEndOffset = this.locateEndOffset(this.document, beginPosition.getEndOffset());
            }
            beginNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginPosition.getStartOffset(), (int)beginEndOffset));
            this.builder.push((IFormatterContainerNode)beginNode);
            this.builder.checkedPop((IFormatterContainerNode)beginNode, beginEndOffset);
            beginNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginEndOffset, (int)beginPosition.getEndOffset()));
        } else {
            SourcePosition bodyNodePosition = bodyNode.getPosition();
            if (beginEndOffset < 0) {
                Node innerBodyNode;
                beginEndOffset = rescueBodyNode instanceof RescueBodyNode ? (!((innerBodyNode = rescueBodyNode.getBodyNode()) instanceof NilImplicitNode) ? innerBodyNode.getPosition().getEndOffset() : rescueBodyNode.getPosition().getEndOffset()) : bodyNode.getPosition().getEndOffset();
            }
            beginNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginPosition.getStartOffset(), (int)bodyNodePosition.getStartOffset()));
            this.builder.push((IFormatterContainerNode)beginNode);
            this.visitChild(visited.getBodyNode());
            this.builder.checkedPop((IFormatterContainerNode)beginNode, -1);
            beginNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)beginNode.getEndOffset(), (int)beginPosition.getEndOffset()));
        }
        return null;
    }

    public Object visitRescueNode(RescueNode visited) {
        this.visitChild(visited.getBodyNode());
        RescueBodyNode rescueBody = visited.getRescueNode();
        int lastBodyEndOffset = -1;
        while (rescueBody != null) {
            FormatterRescueNode rescueNode = new FormatterRescueNode(this.document);
            Node bodyInnerNode = rescueBody.getBodyNode();
            int rescueBeginEndOffset = -1;
            SourcePosition position = rescueBody.getPosition();
            if (!(bodyInnerNode instanceof NilImplicitNode)) {
                SourcePosition innerBodyPosition = bodyInnerNode.getPosition();
                rescueBeginEndOffset = innerBodyPosition.getStartOffset();
                lastBodyEndOffset = innerBodyPosition.getEndOffset();
            } else {
                Node exceptionNodes = rescueBody.getExceptionNodes();
                rescueBeginEndOffset = exceptionNodes != null ? exceptionNodes.getPosition().getEndOffset() : (visited.getElseNode() != null ? visited.getElseNode().getPosition().getStartOffset() : this.document.get(position.getStartOffset(), position.getEndOffset()).lastIndexOf("rescue") + position.getStartOffset() + 6);
                lastBodyEndOffset = rescueBeginEndOffset;
            }
            rescueNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)rescueBeginEndOffset));
            this.builder.push((IFormatterContainerNode)rescueNode);
            this.visitChild(rescueBody.getBodyNode());
            rescueBody = rescueBody.getOptRescueNode();
            int rescueEnd = rescueBody != null ? position.getStartOffset() : (visited.getElseNode() != null ? lastBodyEndOffset : rescueNode.getEndOffset());
            this.builder.checkedPop((IFormatterContainerNode)rescueNode, rescueEnd);
        }
        if (visited.getElseNode() != null) {
            Node elseBranch = visited.getElseNode();
            FormatterRescueElseNode elseNode = new FormatterRescueElseNode(this.document);
            elseNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)lastBodyEndOffset, (int)elseBranch.getPosition().getStartOffset()));
            this.builder.push((IFormatterContainerNode)elseNode);
            this.visitChildren(elseBranch.childNodes());
            this.builder.checkedPop((IFormatterContainerNode)elseNode, -1);
        }
        return null;
    }

    public Object visitEnsureNode(EnsureNode visited) {
        Node bodyNode = visited.getBodyNode();
        this.visitChild(bodyNode);
        FormatterEnsureNode ensureNode = new FormatterEnsureNode(this.document);
        Node node = visited.getEnsureNode();
        SourcePosition position = visited.getPosition();
        int ensureStartOffset = this.document.get(position.getStartOffset(), position.getEndOffset()).lastIndexOf("ensure") + position.getStartOffset();
        ensureNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)ensureStartOffset, (int)node.getPosition().getStartOffset()));
        this.builder.push((IFormatterContainerNode)ensureNode);
        this.visitChildren(node.childNodes());
        this.builder.checkedPop((IFormatterContainerNode)ensureNode, -1);
        return null;
    }

    public Object visitPreExeNode(PreExeNode visited) {
        FormatterAtBeginNode endNode = new FormatterAtBeginNode(this.document);
        endNode.setBegin(this.createTextNode(this.document, (ISourcePositionHolder)visited));
        this.builder.push((IFormatterContainerNode)endNode);
        this.visitChildren((Node)visited);
        SourcePosition position = visited.getPosition();
        Node bodyNode = visited.getBodyNode();
        int bodyEndOffset = bodyNode.getPosition().getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)endNode, bodyEndOffset);
        endNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitPostExeNode(PostExeNode visited) {
        FormatterAtEndNode endNode = new FormatterAtEndNode(this.document);
        endNode.setBegin(this.createTextNode(this.document, (ISourcePositionHolder)visited));
        this.builder.push((IFormatterContainerNode)endNode);
        this.visitChildren((Node)visited);
        SourcePosition position = visited.getPosition();
        Node bodyNode = visited.getBodyNode();
        int bodyEndOffset = bodyNode.getPosition().getEndOffset();
        this.builder.checkedPop((IFormatterContainerNode)endNode, bodyEndOffset);
        endNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEndOffset, (int)position.getEndOffset()));
        return null;
    }

    public Object visitNilNode(NilNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitConstNode(ConstNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitSymbolNode(SymbolNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitStrNode(StrNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitVCallNode(VCallNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitDStrNode(DStrNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitMatch2Node(Match2Node visited) {
        SourcePosition position = visited.getPosition();
        SourcePosition receiverPosition = visited.getReceiverNode().getPosition();
        this.pushTextNode(position.getStartOffset(), receiverPosition.getEndOffset());
        return null;
    }

    public Object visitMatch3Node(Match3Node visited) {
        this.visitNode(visited.getValueNode());
        this.visitNode(visited.getReceiverNode());
        return null;
    }

    public Object visitMatchNode(MatchNode visited) {
        SourcePosition position = visited.getPosition();
        SourcePosition receiverPosition = visited.getRegexpNode().getPosition();
        this.pushTextNode(position.getStartOffset(), receiverPosition.getEndOffset());
        return null;
    }

    public Object visitRegexpNode(RegexpNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitDRegxNode(DRegexpNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitXStrNode(XStrNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    public Object visitFCallNode(FCallNode visited) {
        if (this.isRequireMethod(visited)) {
            SourcePosition position = visited.getPosition();
            FormatterRequireNode requireNode = new FormatterRequireNode(this.document, position.getStartOffset(), position.getEndOffset());
            this.builder.addChild((IFormatterNode)requireNode);
        } else if (visited.getIterNode() != null) {
            int iterStart = visited.getIterNode().getPosition().getStartOffset();
            this.pushTextNode(visited.getPosition().getStartOffset(), iterStart);
            this.visitChild(visited.getIterNode());
        } else {
            this.pushTextNode(visited.getPosition());
        }
        return null;
    }

    public Object visitArrayNode(ArrayNode visited) {
        IFormatterContainerNode containerNode = this.builder.peek();
        if (containerNode.getStartOffset() == visited.getPosition().getStartOffset()) {
            this.visitChildren((Node)visited);
            return null;
        }
        SourcePosition position = visited.getPosition();
        String right = this.document.get(position.getStartOffset(), position.getStartOffset() + 1);
        String left = this.document.get(position.getEndOffset() - 1, position.getEndOffset());
        if ("[".equals(right) && "]".equals(left)) {
            FormatterArrayNode arrayNode = new FormatterArrayNode(this.document);
            arrayNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)(position.getStartOffset() + 1)));
            this.builder.push((IFormatterContainerNode)arrayNode);
            this.visitChildren((Node)visited);
            this.builder.checkedPop((IFormatterContainerNode)arrayNode, position.getEndOffset() - 1);
            arrayNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(position.getEndOffset() - 1), (int)position.getEndOffset()));
            return null;
        }
        return super.visitArrayNode(visited);
    }

    public Object visitHashNode(HashNode visited) {
        SourcePosition position = visited.getPosition();
        String left = this.document.get(position.getStartOffset(), Math.min(position.getStartOffset() + 1, this.document.getLength()));
        String right = this.document.get(Math.max(0, position.getEndOffset() - 1), position.getEndOffset());
        if ("{".equals(left) && "}".equals(right)) {
            FormatterHashNode hashNode = new FormatterHashNode(this.document);
            hashNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)position.getStartOffset(), (int)(position.getStartOffset() + 1)));
            this.builder.push((IFormatterContainerNode)hashNode);
            this.visitChildren((Node)visited);
            this.builder.checkedPop((IFormatterContainerNode)hashNode, position.getEndOffset() - 1);
            hashNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(position.getEndOffset() - 1), (int)position.getEndOffset()));
            return null;
        }
        return super.visitHashNode(visited);
    }

    public Object visitBlockNode(BlockNode visited) {
        this.visitChildren(visited.childNodes());
        return null;
    }

    public Object visitInstAsgnNode(InstAsgnNode visited) {
        this.pushTextNode(visited.getPosition());
        return null;
    }

    private boolean isRequireMethod(FCallNode call) {
        return "require".equals(call.getName()) && call.getArgsNode() instanceof ArrayNode;
    }

    private void visitChildren(Node visited) {
        List children = visited.childNodes();
        if (!children.isEmpty()) {
            this.visitChildren(children);
        }
    }

    private void visitChildren(List<Node> children) {
        for (Node child : children) {
            this.visitChild(child);
        }
    }

    private void visitChild(Node child) {
        block3: {
            if (child != null && this.isVisitable(child)) {
                try {
                    child.accept((NodeVisitor)this);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (!(child instanceof OptArgNode)) break block3;
                    this.visitOptArgNode((OptArgNode)child);
                }
            }
        }
    }

    private boolean isVisitable(Node node) {
        return !(node instanceof ArgumentNode) && node.getClass() != ListNode.class;
    }

    protected IFormatterTextNode createTextNode(IFormatterDocument document, ISourcePositionHolder positionHolder) {
        return this.createTextNode(document, positionHolder.getPosition());
    }

    protected int locateEndOffset(IFormatterDocument document, int rightOffset) {
        String toLocate = "end";
        int wordLength = toLocate.length();
        do {
            int leftOffset;
            String endString;
            if (!toLocate.equals(endString = document.get(leftOffset = rightOffset - wordLength, rightOffset))) continue;
            return leftOffset;
        } while (--rightOffset - wordLength >= 0);
        return rightOffset;
    }

    protected int charLookup(IFormatterDocument document, int offset, char c) {
        while (offset + 1 < document.getLength()) {
            if (document.charAt(offset) == c) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private IFormatterTextNode createTextNode(IFormatterDocument document, SourcePosition position) {
        return AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)document, (int)position.getStartOffset(), (int)position.getEndOffset());
    }

    private void pushTextNode(SourcePosition position) {
        int endOffset;
        int startOffset = position.getStartOffset();
        if (startOffset < (endOffset = position.getEndOffset())) {
            this.pushTextNode(startOffset, endOffset);
        }
    }

    private void pushTextNode(int startOffset, int endOffset) {
        FormatterStringNode strNode = new FormatterStringNode(this.document, startOffset, endOffset);
        this.builder.addChild((IFormatterNode)strNode);
    }

    private boolean isInSameLineExcludingWhitespaces(SourcePosition position) {
        if (position.getStartLine() == position.getEndLine()) {
            return true;
        }
        String text = this.document.get(position.getStartOffset(), position.getEndOffset());
        String[] linesSplit = LINE_SPLIT_PATTERN.split(text);
        if (linesSplit.length == 1) {
            return true;
        }
        if (linesSplit.length > 1) {
            int start = linesSplit[0].trim().length() == 0 ? 0 : 1;
            int end = linesSplit[linesSplit.length - 1].trim().length() == 0 ? linesSplit.length : linesSplit.length - 1;
            boolean allWhiteSpace = true;
            int i = start;
            while (i < end && allWhiteSpace) {
                allWhiteSpace &= linesSplit[i].trim().length() == 0;
                ++i;
            }
            return allWhiteSpace;
        }
        return false;
    }
}

